/*
 * daemon.c -- code for becoming a daemon process
 *
 * $Id: daemon.c,v 1.3 1998/02/06 09:32:32 johns Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/fcntl.h>

#include <unistd.h>
#if 0
#include <syslog.h>
#endif

static int daemonmode = 0;

int daemonize(void) {
  chdir("/");
  umask(0077);

  if (fork() != 0)
    exit(0); 
 
#ifdef BSD
  /* Lose controlling TTY */
  setpgrp(0, getpid());

  { int fd;
    if ((fd = open("/dev/tty", O_RDWR)) >= 0) {
      ioctl(fd, TIOCNOTTY, NULL);
      close(fd);
    } 
  }
#else
  setpgrp();
#endif
 
  fclose(stdout);
  fclose(stdin);
  fclose(stderr);

  daemonmode = 1;

  return 0; 
}


int daemonprint(const char * msg) {

  if (daemonmode) 
#if 0
    syslog(LOG_NOTICE, "%s", msg);        
#endif
    printf("%s", msg);
  else
    printf("%s", msg);

  return 0;
}

