/*
 * devices.h -- Protos for MIDI system structures
 *
 * Copyright 1998  John E. Stone
 *                 j.stone@acm.org
 *                 johns@cs.umr.edu
 *
 * $Id: devices.h,v 1.7 1998/02/18 13:21:09 johns Exp $
 *
 */

#define DEVICE_NO_FLAGS  0
#define DEVICE_HAS_TIMER 1
#define DEVICE_SOMEFLAG1 2 /* flags reserved for use later on */
#define DEVICE_SOMEFLAG2 4
#define DEVICE_SOMEFLAG3 8
#define DEVICE_SOMEFLAG4 16
#define DEVICE_SOMEFLAG5 32
#define DEVICE_SOMEFLAG6 64
/* etc etc ... */

typedef void * MidiDeviceHandle;
typedef char * MidiDeviceSetupParms;

typedef int (* MidiDeviceOpenFunc  )(MidiDeviceSetupParms, MidiDeviceHandle *, int * iofd);
typedef int (* MidiDeviceWriteFunc )(MidiDeviceHandle, MidiIOEvent *);
typedef int (* MidiDeviceReadFunc  )(MidiDeviceHandle, MidiIOEvent *);
typedef int (* MidiDeviceCloseFunc )(MidiDeviceHandle *);

typedef struct {
  char * typename; /* Name of MIDI device type */
  char * version;  /* Any driver version info */
  void * devicehandle; /* device specific handle info */
  unsigned int flags;
  int iofd;        /* file descriptor for use with select */
  MidiDeviceOpenFunc   openfunc;
  MidiDeviceWriteFunc  writefunc;
  MidiDeviceReadFunc   readfunc;
  MidiDeviceCloseFunc  closefunc; 
} MidiDevice;

typedef struct {
  char * typename; /* Name of MIDI device type */
  char * version;  /* Any driver version info */
  unsigned int flags;
  MidiDeviceOpenFunc   openfunc;
  MidiDeviceWriteFunc  writefunc;
  MidiDeviceReadFunc   readfunc;
  MidiDeviceCloseFunc  closefunc; 
} MidiDriver;


typedef struct {
  MidiDevice devices[MAX_DEVICES]; /* Opened MIDI Devices */
  int numdevices;                  /* Number of active MIDI devices */
  MidiDriver drivers[MAX_DRIVERS]; /* MIDI Driver Table */
  int numdrivers;                  /* Number of registered MIDI drivers */
  void * ifds;       /* io descriptors used by input code with select() */
  int maxifd;        /* max io descriptor in use */
} MidiSystem;


typedef int (* AddMIDIDriverFunc   )(MidiSystem *, MidiDriver);


/* drivers.c function protos */
int InitMIDIDrivers(MidiSystem * midisystem);
int AddMIDIDriver(MidiSystem * midisystem, MidiDriver devinfo);
int ConfigMIDIDevices(char * configfile, MidiSystem * midisystem);
int OpenMIDIDevice(char * name, char * parms, MidiSystem * sys);
int CloseMIDIDevices(MidiSystem * midisystem);

int MIDIDeviceWrite(MidiSystem * sys, MidiIOEvent *);
int MIDIDeviceRead(MidiSystem * sys, MidiIOEvent *);

