/*
 * filedrv.c -- File oriented device or FIFO I/O.
 *
 *  Copyright 1998 John E. Stone (j.stone@acm.org)
 *
 *  $Id: filedrv.c,v 1.4 1998/02/25 01:25:43 johns Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "rawdevice.h" /* protos for raw file/device I/O code */
#include "seq.h"       /* protos for MidiIOEvent */
#include "devices.h"   /* protos for device installation code */

#define FILEDRV_INTERNAL
#include "filedrv.h"   /* protos and types for this file */

static char filedrv_drivername[] = "FileDriver";
static char filedrv_version[] = "$Revision: 1.4 $";

int filedrv_drvinst(AddMIDIDriverFunc adddriver, MidiSystem * midisystem) {
  MidiDriver drvinfo;

  drvinfo.typename  = filedrv_drivername;
  drvinfo.version   = filedrv_version;
  drvinfo.flags     = DEVICE_NO_FLAGS;
  drvinfo.openfunc  = filedrv_open;
  drvinfo.writefunc = filedrv_write;   
  drvinfo.readfunc  = filedrv_read;
  drvinfo.closefunc = filedrv_close;

  adddriver(midisystem, drvinfo);

  return 0;
}

int filedrv_open(MidiDeviceSetupParms name, MidiDeviceHandle * handleptr, int *iofd) {
  *iofd = -1;
  return dev_open(name, handleptr, iofd);
}

int filedrv_write(MidiDeviceHandle handle, MidiIOEvent * ev) {
  return dev_write(handle, (char *) ev->msg, ev->msglen);
}

int filedrv_read(MidiDeviceHandle handle, MidiIOEvent * ev) {
  return dev_read(handle, (char *) ev->msg, ev->msglen);
}

int filedrv_close(MidiDeviceHandle * handleptr) {
  return dev_close(handleptr);
}


