/*
 * filetdrv.c -- File oriented device or FIFO I/O.
 *
 *  Copyright 1998 John E. Stone (j.stone@acm.org)
 *
 *  $Id: filetdrv.c,v 1.3 1998/02/25 01:25:43 johns Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "rawdevice.h" /* protos for raw file/device I/O code */
#include "seq.h"       /* protos for MidiIOEvent */
#include "devices.h"   /* protos for device installation code */

#define FILETDRV_INTERNAL
#include "filetdrv.h"   /* protos and types for this file */

static char filetdrv_drivername[] = "FileTDriver";
static char filetdrv_version[] = "$Revision: 1.3 $";

typedef struct {
  unsigned char msg[4];
  long msglen;
  unsigned int sec;
  unsigned int nsec;
} timedmesg;

int filetdrv_drvinst(AddMIDIDriverFunc adddriver, MidiSystem * midisystem) {
  MidiDriver drvinfo;

  drvinfo.typename  = filetdrv_drivername;
  drvinfo.version   = filetdrv_version;
  drvinfo.flags     = DEVICE_HAS_TIMER;
  drvinfo.openfunc  = filetdrv_open;
  drvinfo.writefunc = filetdrv_write;   
  drvinfo.readfunc  = filetdrv_read;
  drvinfo.closefunc = filetdrv_close;

  adddriver(midisystem, drvinfo);

  return 0;
}

int filetdrv_open(MidiDeviceSetupParms name, MidiDeviceHandle * handleptr, int *iofd) {
  *iofd = -1;
  return dev_open(name, handleptr, iofd);
}

int filetdrv_write(MidiDeviceHandle handle, MidiIOEvent * ev) {
  timedmesg m;
  memcpy(m.msg, ev->msg, ev->msglen);
  m.msglen = ev->msglen;
  m.sec = ev->delay.tv_sec;
  m.nsec = ev->delay.tv_nsec;

  return dev_write(handle, (char *) &m, sizeof(timedmesg));
}

int filetdrv_read(MidiDeviceHandle handle, MidiIOEvent * ev) {
  return dev_read(handle, (char *) ev->msg, ev->msglen);
}

int filetdrv_close(MidiDeviceHandle * handleptr) {
  return dev_close(handleptr);
}


