/*
 * loopback.c -- code for doing a simple loopback test of the 
 *               Midiator MS-124W interface.
 *
 * $Id: loopback.c,v 1.5 1998/01/29 21:22:33 johns Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "seq.h"
#include "devices.h"
#include "midiator.h"

int main() {
  MidiDeviceHandle comm;
  MidiIOEvent ev;
  int i, len;

  if (midiator_open("/dev/ttyb", &comm) == -1)
    return -1;

  while (1) {
    ev.msglen = 4;
    len = midiator_read(comm, &ev);
    if (len > 0) {
/*
      for (i=0; i<len; i++) 
        if (buf[i] != 0xf8) 
          printf("%02x ", buf[i]); 
*/
      ev.msglen=len;
      fflush(stdout);
      midiator_write(comm, &ev);
    }
  }

  midiator_close(&comm);
}

