/*
 * midiapi.h -- MIDI API for application programs.   This code wraps all of
 *              the lower level code, and abstract whatever special protocol
 *              the MIDI interface hardware has.
 *
 * Copyright 1998, John E. Stone
 *                 j.stone@acm.org
 *                 johns@cs.umr.edu
 *
 * $Id: midiapi.h,v 1.7 1998/02/18 10:01:14 johns Exp $
 *
 */

#ifdef  __cplusplus
extern "C" {
#endif

void * MidiOpen(void);
int MidiWrite(void * voidhandle, int port, unsigned char msg[4], long stamp, int msglen);
int MidiRead(void * voidhandle, int * port, unsigned char *msg, long *stamp, int *msglen);
void MidiPanic(void * voidhandle);
void MidiClose(void * voidhandle);
void MidiSetTempo(void * voidhandle, int bpm, int ppqn);

#ifdef MIDIIO_PRIVATE
void MidiTimeToRealTime(void * voidhandle, long stamp, struct timespec *t);
#endif

#ifdef  __cplusplus
}
#endif

