#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>

#include "midiapi.h"

int main(int argc, char **argv) {
  void * handle;
  int port, msglen;
  unsigned int channel, note; 
  unsigned char msg[4];
  long stamp;
  struct timeval t;
  int i;

  handle = MidiOpen();
  
  MidiSetTempo(handle, 60, 10);

  t.tv_sec = 0;
  t.tv_usec = 1000;

  while (1) { 
    select(0, NULL, NULL, NULL, &t);

    if (MidiRead(handle, &port, msg, &stamp, &msglen) == 0) {
      printf("port: %d  stamp: %ld  len: %d  data: ",
        port, stamp, msglen);

      for (i=0; i<msglen; i++) 
        printf("%x ", msg[i]);
     
      printf("\n"); 
    }

    msglen = 0; 
    stamp = 0;
    port = 0;
    msg[0] = msg[1] = msg[2] = msg[3] = 0;
  }
  MidiClose(handle);

  return 0;
}

