#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "midiapi.h"

int main(int argc, char **argv) {
  void * handle;
  int port, msglen;
  unsigned int channel, note; 
  unsigned char msg[4];

  if (argc > 2) {
    printf("midipanic: ignoring extra parameters %s ...\n", argv[1]);
  }

  handle = MidiOpen();
  MidiPanic(handle);

  MidiSetTempo(handle, 60, 10);

  for (note=0; note<128; note++) {
    for (port=0; port<4; port++) {
      for (channel=0; channel<16; channel++) {
        msglen = 3;
        msg[0] = 0x90 | (channel & 0xf);
        msg[1] = note;
        msg[2] = 0x4f;
      
        MidiWrite(handle, port, msg, 0, msglen);
      }
    }
    MidiWrite(handle, port, msg, 1, msglen);
  
    for (port=0; port<4; port++) {
      for (channel=0; channel<16; channel++) {
        msglen = 3;
        msg[0] = 0x90 | (channel & 0xf);
        msg[1] = note;
        msg[2] = 0x00;
        MidiWrite(handle, port, msg, 0, msglen);
      }
    }
  }

  MidiPanic(handle);
  MidiClose(handle);

  return 0;
}

