/*
 * ms124t.c -- Machine/OS dependent serial I/O code for Midiator MS-124T
 *
 *  Copyright 1998 John E. Stone (j.stone@acm.org)
 *
 *  $Id: ms124t.c,v 1.2 1998/02/24 17:03:02 johns Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "rawserial.h" /* protos for raw serial I/O code */
#include "seq.h"       /* protos for MidiIOEvent */
#include "devices.h"   /* protos for device installation code */
#include "ms124t.h"  /* protos and types for this file */

static char ms124t_drivername[] = "Midiator-MS-124T";
static char ms124t_version[] = "$Revision: 1.2 $";

int ms124t_drvinst(AddMIDIDriverFunc adddriver, MidiSystem * midisystem) {
  MidiDriver drvinfo;

  drvinfo.typename  = ms124t_drivername;
  drvinfo.version   = ms124t_version;
  drvinfo.flags     = DEVICE_NO_FLAGS;
  drvinfo.openfunc  = ms124t_open;
  drvinfo.writefunc = ms124t_write;   
  drvinfo.readfunc  = ms124t_read;
  drvinfo.closefunc = ms124t_close;

  adddriver(midisystem, drvinfo);

  return 0;
}

int ms124t_open(MidiDeviceSetupParms name, MidiDeviceHandle * handleptr, int *iofd) {
  int rc;

  rc = comm_open(name, 19200, handleptr, iofd);
  *iofd = -1;
  return rc;
}

int ms124t_write(MidiDeviceHandle handle, MidiIOEvent * ev) {
  return comm_write(handle, (char *) ev->msg, ev->msglen);
}

int ms124t_read(MidiDeviceHandle handle, MidiIOEvent * ev) {
  return 0;
}

int ms124t_close(MidiDeviceHandle * handleptr) {
  return comm_close(handleptr);
}


