/*
 * ms124w.c -- Machine/OS dependent serial I/O code for Midiator MS-124W
 *
 *  Copyright 1998 John E. Stone (j.stone@acm.org)
 *
 *  $Id: ms124w.c,v 1.9 1998/02/24 17:02:14 johns Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "rawserial.h" /* protos for raw serial I/O code */
#include "seq.h"       /* protos for MidiIOEvent */
#include "devices.h"   /* protos for device installation code */
#include "ms124w.h"  /* protos and types for this file */

static char ms124w_drivername[] = "Midiator-MS-124W";
static char ms124w_version[] = "$Revision: 1.9 $";

int ms124w_drvinst(AddMIDIDriverFunc adddriver, MidiSystem * midisystem) {
  MidiDriver drvinfo;

  drvinfo.typename  = ms124w_drivername;
  drvinfo.version   = ms124w_version;
  drvinfo.flags     = DEVICE_NO_FLAGS;
  drvinfo.openfunc  = ms124w_open;
  drvinfo.writefunc = ms124w_write;   
  drvinfo.readfunc  = ms124w_read;
  drvinfo.closefunc = ms124w_close;

  adddriver(midisystem, drvinfo);

  return 0;
}

int ms124w_open(MidiDeviceSetupParms name, MidiDeviceHandle * handleptr,
  int *iofd) {
  *iofd = -1;
  return comm_open(name, 38400, handleptr, iofd);
}

int ms124w_write(MidiDeviceHandle handle, MidiIOEvent * ev) {
  int i;
  char buf2[2048];
  memset(buf2, 0xf8, 2024);

  for (i=0; i<ev->msglen; i++)
    buf2[(i * 2) + 1] = ev->msg[i]; 

  return comm_write(handle, buf2, ev->msglen*2);
}

int ms124w_read(MidiDeviceHandle handle, MidiIOEvent * ev) {
  int rc;
  rc = comm_read(handle, (char *) ev->msg, sizeof(ev->msg));

  if (rc < 1) {
    return -1;
  }

  ev->msglen = rc;
  
  return 0;
}

int ms124w_close(MidiDeviceHandle * handleptr) {
  return comm_close(handleptr);
}


