/*
 * msgq.h -- Midi Message Queue Routines
 *
 * Copyright 1998, John E. Stone
 *                 j.stone@acm.org
 *                 johns@cs.umr.edu
 *
 * $Id: msgq.h,v 1.6 1998/02/18 02:19:19 johns Exp $
 *
 */

#define MIDIQ_OUT     1
#define MIDIQ_IN      2

#define QNAME_OUT "/mididout"
#define QNAME_IN  "/mididin"

#define QNUM_OUT 451
#define QNUM_IN  452

#define MIDI_PRIORITY_NORMAL 1
#define MIDI_PRIORITY_HIGH   2

typedef void * QHandle;

QHandle midiq_create(int);
QHandle midiq_open(int);
int midiq_read(QHandle, MidiIOEvent *);
int midiq_write(QHandle, MidiIOEvent *, int);
void midiq_set_nonblock(QHandle);
void midiq_close(QHandle);
void midiq_delete(QHandle, int);

#ifdef MSGQ_PRIVATE

#ifdef POSIXQUEUES

/* POSIX Message Queues */
typedef struct {
  struct mq_attr attr; 
  mqd_t q;
  int nonblock;
} msgqueue;

#else

/* SYSV Message Queues */
typedef struct {
  int key;
  int q;
  int nonblock;
} msgqueue;

#endif
#endif
