/*
 * nulldrv.c -- A do nothing driver, can be used a s template for new code.
 *
 *  Copyright 1998 John E. Stone (j.stone@acm.org)
 *
 *  $Id: nulldrv.c,v 1.4 1998/02/25 01:25:43 johns Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "seq.h"      /* protos for MidiIOEvent */
#include "devices.h"  /* protos for device installation code */

#define NULLDRV_INTERNAL
#include "nulldrv.h"  /* protos and types for this file */

static char nulldrv_drivername[] = "NULL";
static char nulldrv_version[] = "$Revision: 1.4 $";

int nulldrv_drvinst(AddMIDIDriverFunc adddriver, MidiSystem * midisystem) {
  MidiDriver drvinfo;

  drvinfo.typename  = nulldrv_drivername;
  drvinfo.version   = nulldrv_version;
  drvinfo.flags     = DEVICE_NO_FLAGS;
  drvinfo.openfunc  = nulldrv_open;
  drvinfo.writefunc = nulldrv_write;   
  drvinfo.readfunc  = nulldrv_read;
  drvinfo.closefunc = nulldrv_close;

  adddriver(midisystem, drvinfo);

  return 0;
}

int nulldrv_open(MidiDeviceSetupParms name, MidiDeviceHandle * handleptr, int *iofd) {
  *iofd = -1;
  return 0;
}

int nulldrv_write(MidiDeviceHandle handle, MidiIOEvent * ev) {
  return 0;
}

int nulldrv_read(MidiDeviceHandle handle, MidiIOEvent * ev) {
  return 0;
}

int nulldrv_close(MidiDeviceHandle * handleptr) {
  return 0;
}


