/*
 * sc7drv.c -- Machine/OS dependent serial I/O code for Roland Corp. SC-7
 *
 *  Copyright 1998  John Stone   (j.stone@acm.org)
 *                  Rob Fletcher (r.fletcher@york.ac.uk)
 *
 *  $Id: sc7drv.c,v 1.3 1998/02/25 01:25:43 johns Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "rawserial.h" /* protos for raw serial I/O code */
#include "seq.h"       /* protos for MidiIOEvent */
#include "devices.h"   /* protos for device installation code */

#define SC7DRV_INTERNAL
#include "sc7drv.h"       /* protos and types for this file */

static char sc7drv_drivername[] = "SC7";
static char sc7drv_version[] = "$Revision: 1.3 $";

int sc7drv_drvinst(AddMIDIDriverFunc adddriver, MidiSystem * midisystem) {
  MidiDriver drvinfo;

  drvinfo.typename  = sc7drv_drivername;
  drvinfo.version   = sc7drv_version;
  drvinfo.flags     = DEVICE_NO_FLAGS;
  drvinfo.openfunc  = sc7drv_open;
  drvinfo.writefunc = sc7drv_write;   
  drvinfo.readfunc  = sc7drv_read;
  drvinfo.closefunc = sc7drv_close;

  adddriver(midisystem, drvinfo);

  return 0;
}

int sc7drv_open(MidiDeviceSetupParms name, MidiDeviceHandle * handleptr, int *iofd) {
  *iofd = -1;
  return comm_open(name, 38400, handleptr, iofd);
}

int sc7drv_write(MidiDeviceHandle handle, MidiIOEvent * ev) {
  return comm_write(handle, (char *) ev->msg, ev->msglen);
}

int sc7drv_read(MidiDeviceHandle handle, MidiIOEvent * ev) {
  return comm_read(handle, (char *) ev->msg, ev->msglen);
}

int sc7drv_close(MidiDeviceHandle * handleptr) {
  return comm_close(handleptr);
}



