/*
 * seq.h -- Main program for MIDI daemon, controls sequencing of low level
 *          event transmission to the actual MIDI hardware.
 *
 *  Copyright 1998 John E. Stone
 *                 j.stone@acm.org
 *                 johns@cs.umr.edu
 *
 * $Id: seq.h,v 1.6 1998/02/03 22:16:25 johns Exp $
 *
 */

#define MAX_DEVICES 256
#define MAX_DRIVERS 256

typedef struct {
  unsigned int tv_sec;
  unsigned int tv_nsec;
} miditime;

typedef struct {
  long mtype;            /* Message type / priority */
  miditime delay;        /* delay between previous event and this one */
  unsigned char msg[4];  /* up to four bytes of MIDI message */
  int msglen;            /* length of MIDI message in buffer */
  int port;              /* which MIDI port to send the message out on */
} MidiIOEvent;


