/*
 * sgidrv.h -- SGI MIDI driver protos
 *
 *  Copyright 1998 John E. Stone (j.stone@acm.org)
 *
 *  $Id: sgidrv.h,v 1.3 1998/02/24 17:12:04 johns Exp $
 *
 */

int sgidrv_drvinst(AddMIDIDriverFunc, MidiSystem *);

#ifdef SGIDRV_INTERNAL

#define MAXPORTS	10
#define MAXIOPORTS	MAXPORTS * 2

typedef struct {
   int numports;		/* How many ports user has "startmidi'd" */
   MDport port[MAXIOPORTS];	/* Allow MAXIOPORTS ports */
   MDport output;		/* Default output port */
   MDport input;		/* Default input port */
} SGI_ports;


int sgidrv_open(MidiDeviceSetupParms, MidiDeviceHandle *, int *iofd); 
int sgidrv_write(MidiDeviceHandle, MidiIOEvent *); 
int sgidrv_read(MidiDeviceHandle, MidiIOEvent *); 
int sgidrv_close(MidiDeviceHandle *); 

#endif

