/*
 * client.h - data structures used to keep track of all of the
 *            active clients, including any state info, TCP/IP sockets,
 *            and descriptors used for I/O multiplexing, buffering etc.
 *
 */

#define DATABUF_SIZE 128*1024

typedef struct {
  int sockfd;              /* socket file descriptor */
  char * hostname;         /* host name of client */
  char ibuf[DATABUF_SIZE]; /* socket input buffer */
  unsigned long ilen;      /* length of data waiting in the input buffer */
  char obuf[DATABUF_SIZE]; /* socket output buffer */
  unsigned long olen;      /* length of data waiting in the output buffer */
} MidiClient;

typedef struct {
  midiclient * client;
  fd_set sockset;
  int maxfd;   /* highest file descriptor in use for I/O multiplexing */
} MidiSystem;



