/*
 * main.c -- test program for MIDI event parsing code
 *
 * $Id: main.c,v 1.5 1998/02/04 03:06:20 johns Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "midievents.h"

void readmidiport(char * filename, midiHandle * handle) {
  char buf[1024];
  int i, len, fd;

  if ((fd = open(filename, O_RDONLY)) == -1) {
    printf("failed to open %s\n", filename);
    return;
  }
 
  while (1) { 
    len = read(fd, buf, 1023);
  
    if (len > 0) {
      for (i=0; i<len; i++) {
        MidiAddByte(handle, (unsigned char) buf[i]);
      }
    }
  }
 
  close(fd);  
}


int main(int argc, char **argv) {
  midiHandle * handle;

  handle = MidiInit();

  mkfifo(argv[1], 0777);
  if (argc == 2) 
    readmidiport(argv[1], handle);
 
  MidiClose(handle);

  return 0;
}



