
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "miditypes.h"
#include "midifile.h"
#include "util.h"
#include "seq.h"

int main(int argc, char **argv) {
  int i;
  MidiSequence seq;

  printf("MIDI File Player\n");

  if (argc < 2) {
    printf("no filename supplied!\n");
    return -1;
  }

  for (i=1; i<argc; i++) {
    printf("Loading MIDI file %s...\n", argv[i]);
    memset(&seq, 0, sizeof(MidiSequence));

    /* load the midi file */
    if (loadmidifile(argv[i], &seq) == 0) {

      /* print any neato stuff */
      printsequence(&seq);

      /* play sequence */
      playsequence(&seq);    

      /* delete sequence structures from memory */
      FreeSequence(&seq);
    }
    else {
      printf("Skipping file %s...\n", argv[i]);
    }
  }

  return 0;
}




