/*
 * midievents.h -- Midi event parsing code
 *
 * $Id: midievents.h,v 1.3 1998/02/09 01:49:56 johns Exp $
 *
 */

/* MIDI Status Messages */
#define MIDI_NOTE_OFF         0x80
#define MIDI_NOTE_ON          0x90
#define MIDI_KEY_TOUCH        0xA0
#define MIDI_CONTROL          0xB0
#define MIDI_PROG_CHNG        0xC0
#define MIDI_CHAN_TOUCH       0xD0
#define MIDI_PITCHBEND        0xE0
#define MIDI_SYSCOMMON        0xF0

#define MIDI_STATUS_MASK      0x80
#define MIDI_STATUS_TYPE_MASK 0xF0
#define MIDI_CHAN_MASK        0x0F
#define MIDI_DATA_MASK        0x7F

typedef struct {
  unsigned char buf[4]; /* Buffer for MIDI messages */
  int bufpos;
  int buflen;
} midiHandle;


midiHandle * MidiInit(void);
void MidiClose(midiHandle * handle);
void MidiAddByte(midiHandle * handle, unsigned char b, void * synth);

