/*
 * midisim.c - simulate a multitimbral MIDI synthesizer
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "synth.h"
#include "midisim.h"

int perf_init(char * filename, performance * perf) {
  int i;
  
  for (i=0; i<16; i++) {
    synth_init(filename, &perf->channel[i]); 
  }
 
  return 0;
}


int perf_note_on(performance * perf, int channel, int note, int velocity) {
  synth_note_on(&perf->channel[channel-1], note, velocity);
  return 0;
}


int perf_note_off(performance * perf, int channel, int note) {
  synth_note_off(&perf->channel[channel-1], note);
  return 0;
}


int perf_allnotesoff(performance * perf, int channel) {
  synth_allnotesoff(&perf->channel[channel-1]);
  return 0;
}

int perf_generate(performance * perf, unsigned long len, long * outbuf) {
  int i;
  for (i=0; i<16; i++) {
    synth_generate(&perf->channel[i], len, outbuf);
  }
  return 0;
}

