/*
 * midisim.h - simulate a multitimbral MIDI synthesizer
 *
 */

typedef struct {
  instrument channel[16];
} performance;

int perf_init(char * filename, performance * perf);
int perf_note_on(performance * perf, int channel, int note, int velocity);
int perf_note_off(performance * perf, int channel, int note);
int perf_allnotesoff(performance * perf, int channel);
int perf_generate(performance * perf, unsigned long len, long * outbuf);


