/*
 * synth.h -- structures used for holding state of a MIDI synth.
 *
 */

#define NUMOSC 64

#define FREQSHIFT (16)
#define FREQDIV   (1 << 16)

#define OSC_OFF       (0)
#define OSC_ON        (1)
#define OSC_LOOPING   (2)
#define OSC_ONESHOT   (4)
#define OSC_RAWSAMPLE (8)

typedef struct {
  short * samples;       /* the sampled waveform */
  unsigned long length;  /* number of samples in the waveform */
  unsigned long repeatstart;
  unsigned long repeatend;
  unsigned long freq;    /* frequency of raw sample */
} waveform;

typedef struct {
  waveform * wav;        /* the wavetable in use */
  unsigned long wavpos;  /* the current sample number we're on */
  unsigned long wavfrac; /* the current fractional sample */
  unsigned long freq;    /* the current oscillator frequency */
  long volume;           /* the current oscillator volume */
  unsigned int flags;    /* oscillator state flags */
} oscillator;

typedef struct {
  unsigned int state;    /* on off etc.. */
  int osc;               /* which oscillator was used for this note. */
  unsigned long freq;    /* frequency of this note */
} midinote;

typedef struct {
  midinote note[128];      
  oscillator osc[NUMOSC]; /* the oscillators */
  int oscnote[NUMOSC];    /* list of oscillators and their notes */
  unsigned long volume;   /* volume for the whole instrument */
  unsigned long lastosc;  /* most recently used oscillator */
  int pitchbend;
} instrument;


int synth_init(char * filename, instrument * synth);
int synth_notesetup(instrument * synth);
int synth_allnotesoff(instrument * synth);
int synth_note_on(instrument * synth, int midinote, unsigned char velocity);
int synth_note_off(instrument * synth, int midinote);
int synth_generate(instrument * synth, unsigned long len, long * outbuf);


