/* 
 * colorchecker_tables.h - Table of ColorChecker sRGB patch colors and names
 *
 * (C) Copyright 2013-2022 John E. Stone
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * $Id: colorchecker_tables.h,v 1.1 2022/03/23 06:41:57 johns Exp $
 *
 */

/**
 *  \file colorchecker_tables.h
 *  \brief Table of sRGB colors that match the classic pre-2014
 *         ColorChecker charts by Gretag-Macbeth / X-Rite / Calibrite.
 *
 *         The sRGB values are as-reported by X-Rite in 2009, 
 *         for a D65 illuminant:
 *           https://xritephoto.com/documents/literature/en/ColorData-1p_EN.pdf
 *
 *         Classic ColorChecker color rendition chart:
 *           https://home.cis.rit.edu/~cnspci/references/mccamy1976.pdf 
 */



#define COLORCHECKER_NUM_PATCHES 24
static const int colorchecker_maxval = 255;
static const int colorchecker_srgbi[] = {
    115,  82 , 68,  // dark skin
    194, 150, 130,  // light skin
     98, 122, 157,  // blue sky
     87, 108,  67,  // foliage
    133, 128, 177,  // blue flower
    103, 189, 170,  // bluish green

    214, 126,  44,  // orange
     80,  91, 166,  // purple red
    193,  90,  99,  // moderate red
     94,  60, 108,  // purple
    157, 188,  64,  // yellow green
    224, 163,  46,  // orange yellow

     56,  61, 150,  // blue
     70, 148,  73,  // green
    175,  54,  60,  // red 
    231, 199,  31,  // yellow
    187,  86, 149,  // magenta
      8, 133, 161,  // cyan

    243, 243, 242,  // white
    200, 200, 200,  // neutral 8
    160, 160, 160,  // neutral 6.5
    122, 122, 121,  // neutral 5
     85,  85,  85,  // neutral 3.5
     52,  52,  52   // black
};      


#if 0
static const char * colorchecker_names[] = {
    "dark skin",
    "light skin",
    "blue sky",
    "foliage",
    "blue flower",
    "bluish green",

    "orange",
    "purple red",
    "moderate red",
    "purple",
    "yellow green",
    "orange yellow",

    "blue",
    "green",
    "red",
    "yellow",
    "magenta",
    "cyan",

    "white",
    "neutral 8",
    "neutral 6.5",
    "neutral 5",
    "neutral 3.5",
    "black"
};
#endif

