/* 
 * triangle.h - This file contains the defines for triangles etc.
 *
 *  $Id: triangle.h,v 1.17 2002/08/04 21:43:34 johns Exp $
 */

object * newtri(void *, vector, vector, vector);
object * newstri(void *, vector, vector, vector, vector, vector, vector);

#ifdef TRIANGLE_PRIVATE

#define TRIXMAJOR 0
#define TRIYMAJOR 1
#define TRIZMAJOR 2
 
typedef struct {
  RT_OBJECT_HEAD
  vector edge2;
  vector edge1;
  vector v0;
} tri; 

typedef struct {
  RT_OBJECT_HEAD
  vector edge2;
  vector edge1;
  vector v0;
  vector n0;
  vector n1;
  vector n2;
} stri; 

static int tri_bbox(void * obj, vector * min, vector * max);

static void tri_intersect(const tri *, ray *);

static void tri_normal(const tri *, const vector *, const ray *, vector *);
static void stri_normal(const stri *, const vector *, const ray *, vector *);
#endif


